/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOExceptionList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.io.TempDir;

public class FileUtilsCleanDirectoryTestCase {
    @TempDir
    public File top;

    @Test
    public void testCleanEmpty() throws Exception {
        Assertions.assertEquals((int)0, (int)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @Test
    public void testDeletesRegular() throws Exception {
        FileUtils.touch((File)new File(this.top, "regular"));
        FileUtils.touch((File)new File(this.top, ".hidden"));
        Assertions.assertEquals((int)2, (int)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @Test
    public void testDeletesNested() throws Exception {
        File nested = new File(this.top, "nested");
        Assertions.assertTrue((boolean)nested.mkdirs());
        FileUtils.touch((File)new File(nested, "file"));
        Assertions.assertEquals((int)1, (int)this.top.list().length);
        FileUtils.cleanDirectory((File)this.top);
        Assertions.assertEquals((int)0, (int)this.top.list().length);
    }

    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrowsOnNullList() throws Exception {
        Assumptions.assumeTrue((boolean)this.chmod(this.top, 0, false));
        try {
            FileUtils.cleanDirectory((File)this.top);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Unknown I/O error listing contents of directory: " + this.top.getAbsolutePath()), (Object)e.getMessage());
        }
        finally {
            this.chmod(this.top, 755, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DisabledOnOs(value={OS.WINDOWS})
    @Test
    public void testThrowsOnCannotDeleteFile() throws Exception {
        File file = new File(this.top, "restricted");
        FileUtils.touch((File)file);
        Assumptions.assumeTrue((boolean)this.chmod(this.top, 500, false));
        try {
            FileUtils.cleanDirectory((File)this.top);
            Assertions.fail((String)"expected IOException");
        }
        catch (IOException e) {
            IOExceptionList list = (IOExceptionList)e;
            Assertions.assertEquals((Object)("Cannot delete file: " + file.getAbsolutePath()), (Object)list.getCause(0).getMessage());
        }
        finally {
            this.chmod(this.top, 755, false);
        }
    }

    private boolean chmod(File file, int mode, boolean recurse) throws InterruptedException {
        Process proc;
        ArrayList<String> args = new ArrayList<String>();
        args.add("chmod");
        if (recurse) {
            args.add("-R");
        }
        args.add(Integer.toString(mode));
        args.add(file.getAbsolutePath());
        try {
            proc = Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        }
        catch (IOException e) {
            return false;
        }
        return proc.waitFor() == 0;
    }
}

