/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileUtilsWaitForTestCase {
    @Test
    public void testWaitFor() {
        FileUtils.waitFor((File)new File(""), (int)-1);
        FileUtils.waitFor((File)new File(""), (int)2);
    }

    @Test
    public void testWaitForInterrupted() throws InterruptedException {
        AtomicBoolean wasInterrupted = new AtomicBoolean(false);
        CountDownLatch started = new CountDownLatch(1);
        Runnable thread = () -> {
            started.countDown();
            FileUtils.waitFor((File)new File(""), (int)2);
            wasInterrupted.set(Thread.currentThread().isInterrupted());
        };
        Thread thread1 = new Thread(thread);
        thread1.start();
        started.await();
        thread1.interrupt();
        thread1.join();
        Assertions.assertTrue((boolean)wasInterrupted.get());
    }
}

