/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.file.PathUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class PathUtilsContentEqualsTest {
    @TempDir
    public File temporaryFolder;

    private String getName() {
        return this.getClass().getSimpleName();
    }

    @Test
    public void testFileContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals(null, (Path)path1));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)path1, null));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path2, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path2, (Path)path1));
        try {
            PathUtils.fileContentEquals((Path)this.temporaryFolder.toPath(), (Path)this.temporaryFolder.toPath());
            Assertions.fail((String)"Comparing directories should fail with an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Path objFile1 = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".object");
        objFile1.toFile().deleteOnExit();
        PathUtils.copyFile((URL)this.getClass().getResource("/java/lang/Object.class"), (Path)objFile1, (CopyOption[])new CopyOption[0]);
        Path objFile1b = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".object2");
        objFile1b.toFile().deleteOnExit();
        PathUtils.copyFile((URL)this.getClass().getResource("/java/lang/Object.class"), (Path)objFile1b, (CopyOption[])new CopyOption[0]);
        Path objFile2 = Paths.get(this.temporaryFolder.getAbsolutePath(), this.getName() + ".collection");
        objFile2.toFile().deleteOnExit();
        PathUtils.copyFile((URL)this.getClass().getResource("/java/util/Collection.class"), (Path)objFile2, (CopyOption[])new CopyOption[0]);
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)objFile1, (Path)objFile2));
        Assertions.assertFalse((boolean)PathUtils.fileContentEquals((Path)objFile1b, (Path)objFile2));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile1, (Path)objFile1b));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile1, (Path)objFile1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile1b, (Path)objFile1b));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)objFile2, (Path)objFile2));
        Files.createFile(path1, new FileAttribute[0]);
        Files.createFile(path2, new FileAttribute[0]);
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.fileContentEquals((Path)path1, (Path)path2));
    }

    @Test
    public void testDirectoryContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals(null, (Path)path1));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)path1, null));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path1, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path2, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)path2, (Path)path1));
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only1", new String[0]);
        Path dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/directory-files-only1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir1));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryContentEquals((Path)dir2, (Path)dir1));
    }

    @Test
    public void testDirectoryAndFileContentEquals() throws Exception {
        Path path1 = new File(this.temporaryFolder, this.getName()).toPath();
        Path path2 = new File(this.temporaryFolder, this.getName() + "2").toPath();
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals(null, null));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals(null, (Path)path1));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)path1, null));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)path1, (Path)path1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)path1, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)path2, (Path)path2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)path2, (Path)path1));
        Path dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only1", new String[0]);
        Path dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-files-only/directory-files-only2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files/dir2", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1", new String[0]);
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir1));
        Assertions.assertTrue((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir2));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/directory-files-only1", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files/dirs-and-files1/", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir1));
        dir1 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-and-files", new String[0]);
        dir2 = Paths.get("src/test/resources/dir-equals-tests/dir-equals-dirs-then-files", new String[0]);
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)dir1, (Path)dir2));
        Assertions.assertFalse((boolean)PathUtils.directoryAndFileContentEquals((Path)dir2, (Path)dir1));
    }
}

