/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file.spi;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.spi.FileSystemProvider;
import java.util.List;
import org.apache.commons.io.file.spi.FileSystemProviders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileSystemProvidersTest {
    private static final String FILE_PATH = "file:///foo.txt";

    @Test
    public void testGetFileSystemProvider_all() throws URISyntaxException {
        List<FileSystemProvider> installedProviders = FileSystemProvider.installedProviders();
        for (FileSystemProvider fileSystemProvider : installedProviders) {
            String scheme = fileSystemProvider.getScheme();
            URI uri = new URI(scheme, "ssp", "fragment");
            Assertions.assertEquals((Object)scheme, (Object)FileSystemProviders.installed().getFileSystemProvider(uri).getScheme());
        }
    }

    @Test
    public void testGetFileSystemProvider_filePath() {
        Assertions.assertNotNull((Object)FileSystemProviders.getFileSystemProvider((Path)Paths.get(URI.create(FILE_PATH))));
    }

    @Test
    public void testGetFileSystemProvider_fileScheme() {
        Assertions.assertNotNull((Object)FileSystemProviders.installed().getFileSystemProvider("file"));
    }

    @Test
    public void testGetFileSystemProvider_fileURI() {
        Assertions.assertNotNull((Object)FileSystemProviders.installed().getFileSystemProvider(URI.create(FILE_PATH)));
    }

    @Test
    public void testGetFileSystemProvider_fileURL() throws MalformedURLException {
        Assertions.assertNotNull((Object)FileSystemProviders.installed().getFileSystemProvider(new URL(FILE_PATH)));
    }
}

