/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RandomUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AbstractInputStreamTest {
    private byte[] randomBytes;
    protected File inputFile;
    protected InputStream[] inputStreams;

    @BeforeEach
    public void setUp() throws IOException {
        this.randomBytes = RandomUtils.nextBytes((int)0x200000);
        this.inputFile = File.createTempFile("temp-file", ".tmp");
        FileUtils.writeByteArrayToFile((File)this.inputFile, (byte[])this.randomBytes);
    }

    @AfterEach
    public void tearDown() throws IOException {
        this.inputFile.delete();
        for (InputStream is : this.inputStreams) {
            is.close();
        }
    }

    @Test
    public void testBytesSkipped() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (int i = 1024; i < this.randomBytes.length; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testBytesSkippedAfterEOF() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            Assertions.assertEquals((long)this.randomBytes.length, (long)inputStream.skip(this.randomBytes.length + 1));
            Assertions.assertEquals((int)-1, (int)inputStream.read());
        }
    }

    @Test
    public void testBytesSkippedAfterRead() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            int i;
            for (i = 0; i < 1024; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (i = 2048; i < this.randomBytes.length; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testNegativeBytesSkippedAfterRead() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            int i;
            for (i = 0; i < 1024; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(-1024L));
            Assertions.assertEquals((long)0L, (long)inputStream.skip(Long.MIN_VALUE));
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (i = 2048; i < this.randomBytes.length; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testReadMultipleBytes() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            byte[] readBytes = new byte[8192];
            int i = 0;
            while (i < this.randomBytes.length) {
                int read = inputStream.read(readBytes, 0, 8192);
                for (int j = 0; j < read; ++j) {
                    Assertions.assertEquals((byte)this.randomBytes[i], (byte)readBytes[j]);
                    ++i;
                }
            }
        }
    }

    @Test
    public void testReadOneByte() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            for (byte randomByte : this.randomBytes) {
                Assertions.assertEquals((byte)randomByte, (byte)((byte)inputStream.read()));
            }
        }
    }

    @Test
    public void testReadPastEOF() throws IOException {
        int read;
        InputStream is = this.inputStreams[0];
        byte[] buf = new byte[1024];
        while ((read = is.read(buf, 0, buf.length)) != -1) {
        }
        int readAfterEOF = is.read(buf, 0, buf.length);
        Assertions.assertEquals((int)-1, (int)readAfterEOF);
    }

    @Test
    public void testSkipFromFileChannel() throws IOException {
        for (InputStream inputStream : this.inputStreams) {
            int i;
            Assertions.assertEquals((long)1024L, (long)inputStream.skip(1024L));
            for (i = 1024; i < 2048; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
            Assertions.assertEquals((long)256L, (long)inputStream.skip(256L));
            Assertions.assertEquals((long)256L, (long)inputStream.skip(256L));
            Assertions.assertEquals((long)512L, (long)inputStream.skip(512L));
            for (i = 3072; i < this.randomBytes.length; ++i) {
                Assertions.assertEquals((byte)this.randomBytes[i], (byte)((byte)inputStream.read()));
            }
        }
    }
}

