/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CloseShieldInputStreamTest {
    private byte[] data;
    private InputStream original;
    private InputStream shielded;
    private boolean closed;

    @BeforeEach
    public void setUp() {
        this.data = new byte[]{120, 121, 122};
        this.original = new ByteArrayInputStream(this.data){

            @Override
            public void close() {
                CloseShieldInputStreamTest.this.closed = true;
            }
        };
        this.shielded = CloseShieldInputStream.wrap((InputStream)this.original);
        this.closed = false;
    }

    @Test
    public void testClose() throws IOException {
        this.shielded.close();
        Assertions.assertFalse((boolean)this.closed, (String)"closed");
        Assertions.assertEquals((int)-1, (int)this.shielded.read(), (String)"read()");
        Assertions.assertEquals((int)this.data[0], (int)this.original.read(), (String)"read()");
    }
}

