/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.UUID;
import org.apache.commons.io.TaggedIOException;
import org.apache.commons.io.input.BrokenReader;
import org.apache.commons.io.input.ClosedReader;
import org.apache.commons.io.input.TaggedReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TaggedReaderTest {
    @Test
    public void testEmptyReader() throws IOException {
        try (TaggedReader reader = new TaggedReader((Reader)ClosedReader.CLOSED_READER);){
            Assertions.assertFalse((boolean)reader.ready());
            Assertions.assertEquals((int)-1, (int)reader.read());
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1]));
            Assertions.assertEquals((int)-1, (int)reader.read(new char[1], 0, 1));
        }
    }

    @Test
    public void testNormalReader() throws IOException {
        try (TaggedReader reader = new TaggedReader((Reader)new StringReader("abc"));){
            Assertions.assertTrue((boolean)reader.ready());
            Assertions.assertEquals((int)97, (int)reader.read());
            char[] buffer = new char[1];
            Assertions.assertEquals((int)1, (int)reader.read(buffer));
            Assertions.assertEquals((char)'b', (char)buffer[0]);
            Assertions.assertEquals((int)1, (int)reader.read(buffer, 0, 1));
            Assertions.assertEquals((char)'c', (char)buffer[0]);
            Assertions.assertEquals((int)-1, (int)reader.read());
        }
    }

    @Test
    public void testBrokenReader() {
        IOException exception = new IOException("test exception");
        TaggedReader reader = new TaggedReader((Reader)new BrokenReader(exception));
        try {
            reader.ready();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)reader.isCauseOf((Throwable)e));
            try {
                reader.throwIfCauseOf((Throwable)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            reader.read();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)reader.isCauseOf((Throwable)e));
            try {
                reader.throwIfCauseOf((Throwable)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
        try {
            reader.close();
            Assertions.fail((String)"Expected exception not thrown.");
        }
        catch (IOException e) {
            Assertions.assertTrue((boolean)reader.isCauseOf((Throwable)e));
            try {
                reader.throwIfCauseOf((Throwable)e);
                Assertions.fail((String)"Expected exception not thrown.");
            }
            catch (IOException e2) {
                Assertions.assertEquals((Object)exception, (Object)e2);
            }
        }
    }

    @Test
    public void testOtherException() throws Exception {
        IOException exception = new IOException("test exception");
        try (TaggedReader reader = new TaggedReader((Reader)ClosedReader.CLOSED_READER);){
            Assertions.assertFalse((boolean)reader.isCauseOf((Throwable)exception));
            Assertions.assertFalse((boolean)reader.isCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID())));
            reader.throwIfCauseOf((Throwable)exception);
            reader.throwIfCauseOf((Throwable)new TaggedIOException(exception, (Serializable)UUID.randomUUID()));
        }
    }
}

