/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.CharBuffer;
import org.apache.commons.io.input.CharSequenceReader;
import org.apache.commons.io.input.TeeReader;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.io.test.ThrowOnCloseReader;
import org.apache.commons.io.test.ThrowOnCloseWriter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TeeReaderTest {
    private StringBuilderWriter output;
    private Reader tee;

    @BeforeEach
    public void setUp() {
        CharSequenceReader input = new CharSequenceReader((CharSequence)"abc");
        this.output = new StringBuilderWriter();
        this.tee = new TeeReader((Reader)input, (Writer)this.output);
    }

    @Test
    public void testCloseBranchIOException() throws Exception {
        StringReader goodR = (StringReader)Mockito.mock(StringReader.class);
        ThrowOnCloseWriter badW = new ThrowOnCloseWriter();
        TeeReader nonClosingTr = new TeeReader((Reader)goodR, (Writer)((Object)badW), false);
        nonClosingTr.close();
        ((StringReader)Mockito.verify((Object)goodR)).close();
        TeeReader closingTr = new TeeReader((Reader)goodR, (Writer)((Object)badW), true);
        try {
            closingTr.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            ((StringReader)Mockito.verify((Object)goodR, (VerificationMode)Mockito.times((int)2))).close();
        }
    }

    @Test
    public void testCloseMainIOException() throws IOException {
        ThrowOnCloseReader badR = new ThrowOnCloseReader();
        StringWriter goodW = (StringWriter)Mockito.mock(StringWriter.class);
        TeeReader nonClosingTr = new TeeReader((Reader)((Object)badR), (Writer)goodW, false);
        try {
            nonClosingTr.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            ((StringWriter)Mockito.verify((Object)goodW, (VerificationMode)Mockito.never())).close();
        }
        TeeReader closingTr = new TeeReader((Reader)((Object)badR), (Writer)goodW, true);
        try {
            closingTr.close();
            Assertions.fail((String)("Expected " + IOException.class.getName()));
        }
        catch (IOException e) {
            ((StringWriter)Mockito.verify((Object)goodW)).close();
        }
    }

    @Test
    public void testMarkReset() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        this.tee.mark(1);
        Assertions.assertEquals((int)98, (int)this.tee.read());
        this.tee.reset();
        Assertions.assertEquals((int)98, (int)this.tee.read());
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"abbc", (Object)this.output.toString());
    }

    @Test
    public void testReadEverything() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((int)98, (int)this.tee.read());
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString());
    }

    @Test
    public void testReadNothing() {
        Assertions.assertEquals((Object)"", (Object)this.output.toString());
    }

    @Test
    public void testReadOneChar() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((Object)"a", (Object)this.output.toString());
    }

    @Test
    public void testReadToArray() throws Exception {
        char[] buffer = new char[8];
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer));
        Assertions.assertEquals((char)'a', (char)buffer[0]);
        Assertions.assertEquals((char)'b', (char)buffer[1]);
        Assertions.assertEquals((char)'c', (char)buffer[2]);
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer));
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString());
    }

    @Test
    public void testReadToArrayWithOffset() throws Exception {
        char[] buffer = new char[8];
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer, 4, 4));
        Assertions.assertEquals((char)'a', (char)buffer[4]);
        Assertions.assertEquals((char)'b', (char)buffer[5]);
        Assertions.assertEquals((char)'c', (char)buffer[6]);
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer, 4, 4));
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString());
    }

    @Test
    public void testReadToCharBuffer() throws Exception {
        CharBuffer buffer = CharBuffer.allocate(8);
        buffer.position(1);
        Assertions.assertEquals((int)3, (int)this.tee.read(buffer));
        Assertions.assertEquals((int)4, (int)buffer.position());
        buffer.flip();
        buffer.position(1);
        Assertions.assertEquals((char)'a', (char)buffer.charAt(0));
        Assertions.assertEquals((char)'b', (char)buffer.charAt(1));
        Assertions.assertEquals((char)'c', (char)buffer.charAt(2));
        Assertions.assertEquals((int)-1, (int)this.tee.read(buffer));
        Assertions.assertEquals((Object)"abc", (Object)this.output.toString());
    }

    @Test
    public void testSkip() throws Exception {
        Assertions.assertEquals((int)97, (int)this.tee.read());
        Assertions.assertEquals((long)1L, (long)this.tee.skip(1L));
        Assertions.assertEquals((int)99, (int)this.tee.read());
        Assertions.assertEquals((int)-1, (int)this.tee.read());
        Assertions.assertEquals((Object)"ac", (Object)this.output.toString());
    }
}

