/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import org.apache.commons.io.input.MessageDigestCalculatingInputStreamTest;
import org.apache.commons.io.input.ObservableInputStream;
import org.apache.commons.io.input.TimestampedObserver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TimestampedObserverTest {
    @Test
    public void test() throws IOException, InterruptedException {
        Instant before = Instant.now();
        Thread.sleep(20L);
        TimestampedObserver timestampedObserver = new TimestampedObserver();
        Assertions.assertNotNull((Object)timestampedObserver.toString());
        Assertions.assertTrue((boolean)timestampedObserver.getOpenInstant().isAfter(before));
        Assertions.assertTrue((timestampedObserver.getOpenToNowDuration().toNanos() > 0L ? 1 : 0) != 0);
        Assertions.assertNull((Object)timestampedObserver.getCloseInstant());
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer), new ObservableInputStream.Observer[]{timestampedObserver});){
            Assertions.assertTrue((boolean)timestampedObserver.getOpenInstant().isAfter(before));
            Assertions.assertTrue((timestampedObserver.getOpenToNowDuration().toNanos() > 0L ? 1 : 0) != 0);
        }
        Assertions.assertTrue((boolean)timestampedObserver.getOpenInstant().isAfter(before));
        Assertions.assertTrue((timestampedObserver.getOpenToNowDuration().toNanos() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)timestampedObserver.getCloseInstant().isAfter(timestampedObserver.getOpenInstant()));
        Assertions.assertTrue((timestampedObserver.getOpenToCloseDuration().toNanos() > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)timestampedObserver.toString());
    }

    @Test
    public void testExample() throws IOException {
        TimestampedObserver timestampedObserver = new TimestampedObserver();
        byte[] buffer = MessageDigestCalculatingInputStreamTest.generateRandomByteStream(8192);
        ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer), new ObservableInputStream.Observer[]{timestampedObserver});
        Throwable throwable = null;
        if (ois != null) {
            if (throwable != null) {
                try {
                    ois.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            } else {
                ois.close();
            }
        }
    }
}

