/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.io.output.ChunkedOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ChunkedOutputStreamTest {
    @Test
    public void write_four_chunks() throws Exception {
        AtomicInteger numWrites = new AtomicInteger();
        try (ByteArrayOutputStream baos = this.newByteArrayOutputStream(numWrites);
             ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)baos, 10);){
            chunked.write("0123456789012345678901234567891".getBytes());
            Assertions.assertEquals((int)4, (int)numWrites.get());
        }
    }

    @Test
    public void negative_chunksize_not_permitted() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ChunkedOutputStream((OutputStream)new ByteArrayOutputStream(), 0));
    }

    @Test
    public void defaultConstructor() throws IOException {
        AtomicInteger numWrites = new AtomicInteger();
        try (ByteArrayOutputStream baos = this.newByteArrayOutputStream(numWrites);
             ChunkedOutputStream chunked = new ChunkedOutputStream((OutputStream)baos);){
            chunked.write(new byte[4097]);
            Assertions.assertEquals((int)2, (int)numWrites.get());
        }
    }

    private ByteArrayOutputStream newByteArrayOutputStream(final AtomicInteger numWrites) {
        return new ByteArrayOutputStream(){

            public void write(byte[] b, int off, int len) {
                numWrites.incrementAndGet();
                super.write(b, off, len);
            }
        };
    }
}

