/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CountingOutputStreamTest {
    @Test
    public void testCounting() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (CountingOutputStream cos = new CountingOutputStream((OutputStream)baos);){
            int i;
            for (int i2 = 0; i2 < 20; ++i2) {
                cos.write(i2);
            }
            this.assertByteArrayEquals("CountingOutputStream.write(int)", baos.toByteArray(), 0, 20);
            Assertions.assertEquals((int)cos.getCount(), (int)20, (String)"CountingOutputStream.getCount()");
            byte[] array = new byte[10];
            for (i = 20; i < 30; ++i) {
                array[i - 20] = (byte)i;
            }
            cos.write(array);
            this.assertByteArrayEquals("CountingOutputStream.write(byte[])", baos.toByteArray(), 0, 30);
            Assertions.assertEquals((int)cos.getCount(), (int)30, (String)"CountingOutputStream.getCount()");
            for (i = 25; i < 35; ++i) {
                array[i - 25] = (byte)i;
            }
            cos.write(array, 5, 5);
            this.assertByteArrayEquals("CountingOutputStream.write(byte[], int, int)", baos.toByteArray(), 0, 35);
            Assertions.assertEquals((int)cos.getCount(), (int)35, (String)"CountingOutputStream.getCount()");
            int count = cos.resetCount();
            Assertions.assertEquals((int)count, (int)35, (String)"CountingOutputStream.resetCount()");
            for (int i3 = 0; i3 < 10; ++i3) {
                cos.write(i3);
            }
            this.assertByteArrayEquals("CountingOutputStream.write(int)", baos.toByteArray(), 35, 45);
            Assertions.assertEquals((int)cos.getCount(), (int)10, (String)"CountingOutputStream.getCount()");
        }
    }

    @Test
    public void testLargeFiles_IO84() throws Exception {
        long size = 0x80000000L;
        NullInputStream mock = new NullInputStream(0x80000000L);
        CountingOutputStream cos = new CountingOutputStream((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
        IOUtils.copyLarge((InputStream)mock, (OutputStream)cos);
        try {
            cos.getCount();
            Assertions.fail((String)"Expected getCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        try {
            cos.resetCount();
            Assertions.fail((String)"Expected resetCount() to throw an ArithmeticException");
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        mock.close();
        IOUtils.copyLarge((InputStream)mock, (OutputStream)cos);
        Assertions.assertEquals((long)0x80000000L, (long)cos.getByteCount(), (String)"getByteCount()");
        Assertions.assertEquals((long)0x80000000L, (long)cos.resetByteCount(), (String)"resetByteCount()");
    }

    private void assertByteArrayEquals(String msg, byte[] array, int start, int end) {
        for (int i = start; i < end; ++i) {
            Assertions.assertEquals((int)array[i], (int)(i - start), (String)(msg + ": array[" + i + "] mismatch"));
        }
    }
}

